"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PublicService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const product_entity_1 = require("../../entities/product.entity");
const category_entity_1 = require("../../entities/category.entity");
const business_setting_entity_1 = require("../../entities/business-setting.entity");
let PublicService = class PublicService {
    productRepo;
    categoryRepo;
    settingRepo;
    constructor(productRepo, categoryRepo, settingRepo) {
        this.productRepo = productRepo;
        this.categoryRepo = categoryRepo;
        this.settingRepo = settingRepo;
    }
    async getFeaturedProducts() {
        return this.productRepo.find({
            where: { isFeatured: true },
            take: 10,
            relations: ['category', 'vendor'],
            order: { createdAt: 'DESC' },
        });
    }
    async getAllCategories() {
        return this.categoryRepo.find({
            order: { name: 'ASC' },
        });
    }
    async getProductsByCategory(categoryId) {
        const category = await this.categoryRepo.findOne({
            where: { id: categoryId },
        });
        if (!category)
            throw new common_1.NotFoundException('Category not found');
        return this.productRepo.find({
            where: { category: { id: categoryId } },
            relations: ['vendor'],
            take: 20,
            order: { createdAt: 'DESC' },
        });
    }
    async getBusinessSettings() {
        const settings = await this.settingRepo.find();
        return settings.reduce((acc, setting) => {
            acc[setting.key] = setting.value;
            return acc;
        }, {});
    }
    async searchProducts(query) {
        if (!query || query.trim().length < 2) {
            return [];
        }
        return this.productRepo.find({
            where: [
                { name: (0, typeorm_2.ILike)(`%${query}%`) },
                { description: (0, typeorm_2.ILike)(`%${query}%`) },
            ],
            take: 15,
            order: { createdAt: 'DESC' },
        });
    }
};
exports.PublicService = PublicService;
exports.PublicService = PublicService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(product_entity_1.Product)),
    __param(1, (0, typeorm_1.InjectRepository)(category_entity_1.Category)),
    __param(2, (0, typeorm_1.InjectRepository)(business_setting_entity_1.BusinessSetting)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository])
], PublicService);
//# sourceMappingURL=public.service.js.map